[iscript]
kag.tagHandlers.ori_image =
	function(elm)
	{
		// 画像読み込み
		updateBeforeCh = 1;
		getLayerFromElm(elm).loadImages(elm);
		if(global.zoom_object !== void) global.zoom_object.initLayerInfo(elm.page, elm.layer);
		return 0;
	} incontextof kag;
	
kag.tagHandlers.image =
	function(elm)
	{
		// 画像読み込み
		updateBeforeCh = 1;
		getLayerFromElm(elm).loadImages(elm);
		if(global.zoom_object !== void) global.zoom_object.initLayerInfo(elm.page, elm.layer);
		if(elm.noflag !== true) sf.cg[elm.storage] = true;
		return 0;
	} incontextof kag;

kag.tagHandlers.freeimage = 
	function(elm)
	{
		// 画像のクリア
		updateBeforeCh = 1;
		getLayerFromElm(elm).freeImage(elm);
		if(global.zoom_object !== void) global.zoom_object.initLayerInfo(elm.page, elm.layer);
		kag.childImage.clearImage(elm);
		return 0;
	} incontextof kag;

// [backlay] (ChildImageへの対応)
kag.tagHandlers.backlay =
	function(elm)
	{
		// レイヤを裏画面にコピー
		updateBeforeCh = 1;
		backupLayer(elm, true);
		if(global.zoom_object !== void) global.zoom_object.initLayerInfo('back', elm.layer);
		kag.childImage.copyImagesToBack(elm);
		return 0;
	} incontextof kag;

kag.tagHandlers.copylay =
	function(elm)
	{
		// 同種のレイヤ同士のコピー
		updateBeforeCh = 1;
		copyLayer(elm);
		if(global.zoom_object !== void) global.zoom_object.initLayerInfo(elm.destpage, elm.destlayer);
		return 0;
	} incontextof kag;

kag.tagHandlers.l =
	function(elm)
	{
		// メッセージ履歴のアクションをクリア
		if(historyWriteEnabled) historyLayer.clearAction();
		
		// ボイス再生待ち
		if(autoMode) waitSEStop(%[buf : global.SOUND_BUFFER.VOICE, canskip : false]);
		
		if(skipMode == 1) skipMode = 0;
		
		// 記録用文章メモ更新
		historyLayer.flushLastSentence();
		
		// 行クリック待ち
		return showLineBreak(elm);
	} incontextof kag;

kag.tagHandlers.ori_p = 
	function(elm)
	{
		// メッセージ履歴のアクションをクリア
		if(historyWriteEnabled) historyLayer.clearAction();
		
		// ボイス再生待ち
		if(autoMode && !kag.config.MuteVoice && !kag.msgWin.getCVMute()) waitSEStop(%[buf : global.SOUND_BUFFER.VOICE, canskip : false]);
		
		if(skipMode == 1) skipMode = 0;
		
		// 記録用文章メモ更新
		historyLayer.flushLastSentence();
		
		historyLayer.doneRepage = true;
		
		if(historyWriteEnabled) historyLayer.reline();
		
		if(showHistoryTrigger !== void) showHistoryTrigger();
		
		// ページクリック待ち
		return showPageBreak(elm);
	} incontextof kag;

kag.tagHandlers.s =
	function(elm)
	{
		// 実行停止
		stablePosibility = true;
		//if(!usingExtraConductor) incRecordLabel(true);
		inSleep = true;
		if(recordHistoryOfStore == 2) // 2 : 選択肢 ( @s タグ ) ごと
			setToRecordHistory();
		notifyStable();

        // メッセージレイヤタイムアウト呼び出し開始
        current.startTimeout();

		return -1;
	} incontextof kag;
	
kag.tagHandlers.trans =
	function(elm)
	{
		if(!kag.config.ScreenEffect && !kag.forceEffect) elm.time = 0;
		
		for(var i = 0; i < kag.numCharacterLayers; i++)
		{
			if(kag.fore.layers[i].Anim_storageName != "")
			{
				kag.fore.layers[i].clearAnim();
			}
		}
		
		// トランジションの開始
		kag.stopAllTransitions();
		getLayerPageFromElm(elm, false).beginTransition(elm);
		return 0;
	} incontextof kag;

kag.tagHandlers.playvideo =
	function(elm)
	{
		// ムービーを再生する
		if(config.MoviePlay)
		{
			cancelSkip();
			cancelAutoMode();
			movies[+elm.slot].play(elm.storage);
			msgWin.hide();
		}
		return 0;
	} incontextof kag;

kag.tagHandlers.playse =
	function(elm)
	{
		// 効果音の再生
		if(Storages.getPlacedPath(elm.storage + ".wav") != "" ||
		   Storages.getPlacedPath(elm.storage + ".ogg") != "")
		{
			se[+elm.buf].play(elm);
		}
		return 0;
	} incontextof kag;

kag.tagHandlers.playhse =
	function(elm)
	{
		// 効果音の再生
		elm.loop = kag.config.HseLoop;
		se[+elm.buf].play(elm);
		return 0;
	} incontextof kag;

kag.tagHandlers.ori_wt = kag.tagHandlers.wt;

kag.tagHandlers.videolayer = 
	function(elm)
	{
		with(kag.getLayerFromElm(elm))
		{
			.setPos(0, 0, kag.fore.base.width, kag.fore.base.height);
			.type = ltOpaque;
			.fillRect(0, 0, .width, .height, elm.fill === void ? 0 : elm.fill);
		}
		movies[+elm.slot].storeLayer( elm.layer, elm.page, elm.channel );
		movies[+elm.slot].setVideoLayer(getLayerFromElm(elm),elm);
		movies[+elm.slot].opened = false;
		return 0;
	} incontextof kag;
[endscript]

[macro name=wt]
[ori_wt *][label]
[endmacro]

[macro name=p]
[ori_p *]
[if exp="kag.config.VoiceStop"]
	[eval exp="kag.se[global.SOUND_BUFFER.VOICE].position = kag.se[global.SOUND_BUFFER.VOICE].totalTime-1;" cond="kag.se[global.SOUND_BUFFER.VOICE].status != 'unload'"]
	[eval exp="kag.bgv.autoresume();"]
[endif]
[eval exp="kag.se[global.SOUND_BUFFER.VOICE_REPEAT].stop()"]
[endmacro]

[return]