[iscript]
// メッセージウィンドウ構築
KAGLoadScript('MessageWindowController.tjs');
kag.addPlugin(kag.msgWin = new MessageWindowController());
kag.flags.messageWindow = -1;

kag.allocateMessageLayers =
	function(num, setdefaultfont = true)
	{
		// メッセージレイヤ数を num に設定する
		if(fore.messages.count > num)
		{
			// レイヤが減る
			for(var i = num; i<fore.messages.count; i++)
			{
				if(current == fore.messages[i] || current == back.messages[i])
					current = fore.messages[0], currentNum = 0, currentPage = 0;
				invalidate fore.messages[i];
				invalidate back.messages[i];
			}
			fore.messages.count = num;
			back.messages.count = num;
		}
		else if(fore.messages.count < num)
		{
			// レイヤが増える
			for(var i = fore.messages.count; i<num; i++)
			{
				fore.messages[i] = new MessageLayer(this, fore.base, "表メッセージレイヤ" + i, i, true);
				back.messages[i] = new MessageLayer(this, back.base, "裏メッセージレイヤ" + i, i, true);
				fore.messages[i].setCompLayer(back.messages[i]);
				back.messages[i].setCompLayer(fore.messages[i]);
				fore.messages[i].clear();
				back.messages[i].clear();
			}
			reorderLayers();
			if(setdefaultfont) setMessageLayerUserFont();
		}
		numMessageLayers = num;
	} incontextof kag;

// 名前入力対応[cv]タグ用str属性返却メソッド
function cvstr(mp)
{
	if (nameInputChanged())
	{
		// 名前入力変更時
		return mp.strnn != void ? mp.strnn : mp.str;
	} else {
		// 名前入力デフォルト時
		return mp.str;
	}
}
[endscript]

[laycount messages=1]

; ==== メッセージレイヤ0設定 ====
[position layer=message0 page=fore frame="" left=0 top=440 width=1280 height=280 marginl=210 margint=125 marginr=200 marginb=25]
[position layer=message0 page=back frame="" left=0 top=440 width=1280 height=280 marginl=210 margint=125 marginr=200 marginb=25]
[layopt layer=message0 page=fore visible=false]
[layopt layer=message0 page=back visible=false]
; フォント設定
[current layer=message0 page=back][deffont size=26 face=MPLUS1C26 color=0xFFFFFF edge=true edgecolor=0x000000 shadow=true shadowcolor=0x000000][resetfont][defstyle linespacing=14][resetstyle]
[current layer=message0 page=fore][deffont size=26 face=MPLUS1C26 color=0xFFFFFF edge=true edgecolor=0x000000 shadow=true shadowcolor=0x000000][resetfont][defstyle linespacing=14][resetstyle]
; 描画フォントの影属性
[iscript]
kag.fore.messages[0].edgeExtent = 2;
kag.fore.messages[0].edgeEmphasis = 1500;
kag.back.messages[0].edgeExtent = kag.fore.messages[0].edgeExtent;
kag.back.messages[0].edgeEmphasis = kag.fore.messages[0].edgeEmphasis;
[endscript]
; ===============================

; ==== メッセージレイヤ1設定 ====
;[position layer=message1 page=fore frame="" left=0 top=0 width=1280 height=720 marginl=0 margint=0 marginr=0 marginb=0 color=0x000000 opacity=128]
;[position layer=message1 page=back frame="" left=0 top=0 width=1280 height=720 marginl=0 margint=0 marginr=0 marginb=0 color=0x000000 opacity=128]
;[layopt layer=message1 page=fore visible=false]
;[layopt layer=message1 page=back visible=false]
; フォント設定
;[current layer=message1 page=back][deffont size=26 face=MPLUS1C26 color=0xFFFFFF edge=true edgecolor=0x000000 shadow=true shadowcolor=0x000000][resetfont][defstyle linespacing=14][resetstyle]
;[current layer=message1 page=fore][deffont size=26 face=MPLUS1C26 color=0xFFFFFF edge=true edgecolor=0x000000 shadow=true shadowcolor=0x000000][resetfont][defstyle linespacing=14][resetstyle]
; 描画フォントの影属性
;[iscript]
;kag.fore.messages[1].edgeExtent = 2;
;kag.fore.messages[1].edgeEmphasis = 1500;
;kag.back.messages[1].edgeExtent = kag.fore.messages[1].edgeExtent;
;kag.back.messages[1].edgeEmphasis = kag.fore.messages[1].edgeEmphasis;
;[endscript]
; ===============================

[current layer=message0]


; メッセージウィンドウ切り替えマクロ
[macro name=msgwin]
[if exp="mp.page == 'no'"]
	[eval exp="kag.msgWin.hide()"]
[else]
	[layopt layer=message page=fore visible=false]
	[layopt layer=message page=back visible=false]
	[current layer=&"'message'+mp.page"]
	[if exp="mp.page == 0 || mp.page === void"]
		[eval exp="kag.msgWin.show()"]
	[else]
		[eval exp="kag.msgWin.hide()"]
		[layopt layer=message page=fore visible=true]
		[layopt layer=message page=back visible=true]
	[endif]
[endif]
[endmacro]

; ネームマクロ
[macro name=msgname]
[if exp="global.NAME_LIST_KEYS.find(mp.name !== void ? mp.name.toUpperCase() : '') >= 0 || mp.name === void"]
	[eval exp="kag.msgWin.setName(mp)"]
	[else]
	[eval exp="System.inform('[msgname]タグエラー：\n未定義のネームIDです。\n\nname=' + mp.name)"]
[endif]
[label]
[endmacro]

; ボイスマクロ
[macro name=cv]
[eval exp="kag.msgWin.setCVVolume(mp.cvname !== void ? mp.cvname : mp.name)"]
[playse buf=&global.SOUND_BUFFER.VOICE storage=&cvstr(mp) cond="kag.skipMode == 0 || kag.forceEffect"]
[eval exp="kag.bgv.autopause(kag.se[global.SOUND_BUFFER.VOICE].totalTime)" cond="kag.se[global.SOUND_BUFFER.VOICE].status == 'play'"]
[eval exp="kag.msgWin.repeatVoice = cvstr(mp)"]
[eval exp="kag.msgWin.repeatVoiceID = mp.cvname !== void ? mp.cvname : mp.name"]
[if exp="global.NAME_LIST_KEYS.find(mp.name !== void ? mp.name.toUpperCase() : '') >= 0 || mp.name === void"]
	[eval exp="kag.msgWin.setName(%[name : mp.name, action : cvstr(mp), cvname : mp.cvname, serifColor : mp.serifcolor])"]
	[else]
	[eval exp="System.inform('[cv]タグエラー：\n未定義のネームIDです。\n\nname=' + mp.name)"]
[endif]
[endmacro]

; メッセージウィンドウ非表示トランジション
[macro name=transnowin]
[msgwin page=no]
[trans *][wt canskip=true]
[msgwin]
[endmacro]

[return]
