[iscript]
kag.keyDownHook.add(
	function(key, shift)
	{
		// Yes/Noダイアログ表示時
		if(typeof kag.diagAsk != UNDEFINED && kag.diagAsk.actionable)
		{
			kag.diagAsk.onKeyDown(key, shift);
			return true;
		}
		
		// コンフィグ画面表示時
		if(typeof kag.configWindow != UNDEFINED && kag.configWindow.visible)
		{
			kag.configWindow.onKeyDown(key, shift);
			return true;
		}
		
		// セーブ/ロード画面表示時
		if(typeof kag.saveWindow != UNDEFINED && kag.saveWindow.visible)
		{
			kag.saveWindow.onKeyDown(key, shift);
			return true;
		}
		
		// バックログ表示時
		if(kag.historyShowing)
		{
			return true;
		}
		
		// Choiceダイアログ表示時
		if(typeof kag.diagChoice != UNDEFINED && typeof kag.configWindow != UNDEFINED && typeof kag.saveWindow != UNDEFINED)
		{
			if(kag.diagChoice.actionable && !kag.configWindow.visible && !kag.saveWindow.visible)
			{
				if(key != VK_ESCAPE && key != VK_SPACE)
				{
					kag.diagChoice.onKeyDown(key, shift);
					return true;
				}
			}
		}
		
		// 会話切替クロージング処理時
		if(typeof kag.switchMessage != UNDEFINED && kag.switchMessage.closing)
		{
			return true;
		}
		
		// 会話切替表示時
		if(typeof kag.switchMessage != UNDEFINED && kag.switchMessage.enabled)
		{
			if(!kag.switchMessage.onKeyDown(key, shift)) return true;
		}
		
		// 通常時
		if(typeof kag.configWindow != UNDEFINED && typeof kag.saveWindow != UNDEFINED)
		{
			if(!kag.configWindow.visible && !kag.saveWindow.visible)
			{
				if(!kag.msgWin.onKeyDown(key, shift)) return(false);
			}
		}
		
		return(true);
	});
[endscript]

[return]
