[iscript]
kag.onMouseWheel = 
	function(shift, delta, x, y)
	{
		// ホイールが回転した
		global.Window.onMouseWheel(...);
		
		// メッセージ窓のホイール処理
		if (inSleep && current.hasWheel()) {
			current.processWheel(shift, delta, x, y);
			return;
		}
		
		if(diagAsk.visible) return;
		
		// バックログ表示時
		if(historyLayer.visible)
		{
			historyLayer.windowMouseWheel(shift, delta, x, y);
			return;
		}
		
		// コンフィグ画面表示時
		if(configWindow.visible)
		{
			configWindow.onMouseWheel(shift, delta, x, y);
			return;
		}
		
		// セーブ/ロード画面表示時
		if(saveWindow.visible)
		{
			saveWindow.onMouseWheel(shift, delta, x, y);
			return;
		}
		
		// 名前入力画面表示時
		if(typeof this.nameInput != UNDEFINED && nameInput isvalid && nameInput.visible)
		{
			return;
		}
		
		// クイックロード中
		if(msgWin.quickLoading) return;
		
		// ムービー再生中
		if(movies[0].lastStatus == "play") return;
		
		if(delta > 0)
		{
			if(!kag.flags.titleshow &&
			   !kag.flags.lockHistory &&
			   !kag.msgWin.inTransition() &&
			   (typeof kag.mapWalk == UNDEFINED || !kag.mapWalk.visible) &&
			   !kag.skipKeyPressing() &&
			   !kag.conductor.timeOutTimer.enabled)
			{
				cancelSkip();
				cancelAutoMode();
				onShowHistoryMenuItemClick(); // メッセージ履歴を表示
			}
		}
		else if(System.getTickCount() - lastHistoryHiddenTick > 150) 
		{
			onPrimaryClick(); // クリックをエミュレート
			// ↑ tick を比較しているのは、メッセージ履歴を隠す操作とホイールを
			// 手前に回す操作が連続した場合に勝手に読み進むのをある程度防ぐ仕掛け
		}
	} incontextof kag;

kag.checkProceedingKey = 
	function(key, shift)
	{
		// key が読みすすみのキー ( スペースキーかReturnキー ) の場合は
		// キーを処理し、true を返す。そうでなければ false を返す
		if((key == VK_RETURN || key == supportReadingKey) && !kag.msgWin.quickLoading)
		{
			// キーがメッセージキューに溜まってる場合があるので
			// 実際にそのキーが押されているのかどうかを
			// getKeyState を用いて調べる
			var sg = getKeyState;
			if(sg(VK_RETURN) || sg(supportReadingKey))
			{
				// キーが押されてた
				if((shift & ssRepeat) && clickSkipEnabled)
				{
					// キーリピート
					if(skipMode != 4 && skipKeyRepressed)
						skipToStop2(); // まだskipMode 4に入っていない場合は早送りモードに入る
					// skipKeyRepressed をチェックするのは
					// 連続してキーリピートが発生しているときに
					// cancelSkip 後にスキップに突入するのを防ぐため
				}
				else
				{
					skipKeyRepressed = true;
					onPrimaryClickByKey();
				}
				return true;
			}
		}
		
		if(key == VK_CONTROL && !kag.msgWin.quickLoading && (typeof kag.mapWalk == UNDEFINED || !kag.mapWalk.visible) && !kag.inSleep)
		{
			cancelAutoMode();
			clickSkipEnabled = true;
			skipToStop2();
			return true;
		}
		
		return false;
	} incontextof kag;

kag.skipKeyPressing = 
	function()
	{
		// VK_RETURN あるいは supportReadingKey が押されているかどうか
		var sg = getKeyState;
		return sg(VK_RETURN) || sg(supportReadingKey) || sg(VK_SPACE) || sg(VK_CONTROL);
	} incontextof kag;

kag.onConductorLabel =
	function(label, page)
	{
		// コンダクタがラベルを通過した
		if(!usingExtraConductor)
		{
			incRecordLabel(true);
			setRecordLabel(conductor.curStorage, label);
		}
		setUserSpeed();
		if(!usingExtraConductor)
		{
			if(!getCurrentRead() && skipMode != 4 && !config.ForceSkip)
				cancelSkip(); // 未読なのでスキップを停止
			currentLabel = label;
		}
		if(page !== void && page !== '')
		{
			if(page[0] == '&') page = Scripts.eval((page.substring(1)));
			currentPageName = page;
		}
		if(page !== void)
		{
			pushHistoryOfStore();
			stablePosibility = false;
			dm(conductor.curStorage + " : ラベル/ページ : " + label + "/" + currentPageName);
			if(usingExtraConductor) throw new Exception("右クリックサブルーチン内/extraCondutor"
				"サブルーチン内では保存可能なラベルを記述できません");
			storeFlags(), storeLabelPassed = true, setMenuAccessibleAll();
			if(recordHistoryOfStore == 1) // 1 : 保存可能なラベルごと
				setToRecordHistory();
		}
		return true;
	} incontextof kag;

kag.onConductorAfterReturn =
	function()
	{
		// コンダクタが return タグを実行した後
		if(!usingExtraConductor)
		{
			setRecordLabel(conductor.curStorage, currentLabel = conductor.curLabel);
		}
		setUserSpeed();
		if(!usingExtraConductor)
		{
			if(!getCurrentRead() && skipMode != 4 && !config.ForceSkip)
				cancelSkip(); // 未読なのでスキップを停止
		}
	} incontextof kag;

kag.showPageBreak =
	function(elm)
	{
		// 現在のメッセージレイヤにページ待ち記号を表示する
		stablePosibility = true;
		if(skipMode == 1 || skipMode == 2) cancelSkip();
		if(skipMode == 4 && !skipKeyPressing()) cancelSkip();
		if(skipMode) return -4; // いったんイベントを処理
		if(autoMode)
		{
			// 自動読みすすみの場合
			return autoModePageWait;
		}

		current.showPageBreakGlyph(pageBreak);
		storeClickGlyphState("page");

		if(!current.nodeVisible)
		{
			dm("警告 : 非表示になっている" +
				(currentPage ? "裏" : "表") + "メッセージレイヤ" + currentNum +
				"でページクリック待ちになりました");
		}

		// conductor を 'click' まで待ち状態に
		conductor.wait(%[
			click : function
			{
				clickWaiting = false;
				fore.base.cursor = cursorDefault;
				notifyRun();
				msgWin.repeatVoice = void;
				msgWin.repeatVoiceID = void;
			} incontextof this
			]);
		clickWaiting = true;
		fore.base.cursor = cursorWaitingClick;
		notifyStable();
		return -2;
	} incontextof kag;

kag.cancelAutoMode =
 	function()
	{
		// 自動読みすすみモードのキャンセル
		if(autoMode)
		{
			autoMode = false;
			var t = conductor.lastTagName;
			if(t == 'np' || t == 'p' || t == 'ori_p'){
				showPageBreak();
			}
			else if(t == 'l'){
				showLineBreak(%[canskip: false]);
			}
		}
		msgWin.turnAutoButton(false);
	} incontextof kag;

kag.enterAutoMode =
	function()
	{
		if(se[global.SOUND_BUFFER.VOICE].status != "play")
		{
			onPrimaryClick();
		}
		else
		{
			if(conductor.lastTagName != "ch")
			{
				waitSEStop(%[buf : global.SOUND_BUFFER.VOICE, canskip : false]);
				onPrimaryClick(); // クリックの動作をエミュレートする
				skipMode = 1;
			}
		}
		msgWin.turnAutoButton(true);
		autoMode = true;
	} incontextof kag;

kag.skipToStop =
	function()
	{
		// 次の停止までスキップ
		onPrimaryClick(); // クリックの動作をエミュレートする
		skipMode = 3;
		actualChSpeed = 1;
		msgWin.turnSkipButton(true);
	} incontextof kag;

kag.skipToStop2 =
	function()
	{
		// 次の停止までスキップ(早送りモード)
		onPrimaryClick();
		skipMode = 4;
		actualChSpeed = 1;
		msgWin.turnSkipButton(true);
	} incontextof kag;

kag.cancelSkip =
	function()
	{
		// スキップ動作をキャンセル
		if(skipMode == 4) skipKeyRepressed = false;
		skipMode = 0;
		actualChSpeed = chSpeed;
		msgWin.turnSkipButton(false);
	} incontextof kag;
	
kag.onCloseQuery_ori = kag.onCloseQuery;
kag.onCloseQuery =
	function()
	{
		if(msgWin.quickLoading) return(true);
		
		cancelSkip();
		cancelAutoMode();
		skipToClick();
		
		if(diagAsk.enabled)
		{
			diagAsk.show(%[
				callback : function(result) {
					skipMode = 0;
					if(result)
					{
						if(kag.configWindow.visible) kag.configWindow.setSystemFromSetting(kag.configWindow.getSettingFromControl());
						saveSystemVariables();
						saveWindow.enabled = false;
						configWindow.enabled = false;
						process("first.ks", "*gameend");
					}
				} incontextof kag,
				message0 : "ゲームを終了します",
				message1 : "よろしいですか？",
				forceShow : true,
				key : "exit"
			]);
		}
		else
		{
			global.closeQuery();
		}
	} incontextof kag;

kag.goToStartWithAsk =
	function()
	{
		if(flags.titleshow || diagAsk.visible || msgWin.quickLoading) return;
		
		cancelSkip();
		cancelAutoMode();
		skipToClick();
		
		if(movies[0].lastStatus != "play" || true)
		{
			diagAsk.show(%[
				callback : function(result) {
					skipMode = 0;
					if(result)
					{
						saveWindow.enabled = false;
						configWindow.enabled = false;
						process("first.ks", "*titlereturn");
					}
				} incontextof kag,
				message0 : "タイトル画面に戻ります",
				message1 : "よろしいですか？",
				key : "title"
			]);
		}
		else
		{
			var ret = askYesNo("タイトル画面に戻ります。よろしいですか？", "タイトル画面に戻る");
			if(ret)
			{
				movies[0].stop();
				saveSystemVariables();
				kag.bgv.clearReplay();
				configWindow.hide(0);
				saveWindow.hide(0);
				process("first.ks", "*titlereturn");
			}
		}		
	} incontextof kag;

kag.loadBookMarkFromFile =
	function(fn, loaduser = true)
	{
		// ファイル fn から栞を読み込む
		// loaduser が false の時は user を読み込まない
		try
		{
			if(!Storages.isExistentStorage(fn)) return false; //ファイルがない

			var data;

			var modestr;

			if(saveThumbnail)
			{
				// 指定オフセットからデータを読み込む
				modestr += "o" + calcThumbnailSize().size;
			}

			data = Scripts.evalStorage(fn, modestr);

			if(data.id != saveDataID)
			{
				System.inform("他のシステムのデータを読み込もうとしました", "エラー");
				return false;
			}

			pcflags = data.core;
			pcflags = %[] if pcflags === void;
			if(loaduser)
			{
				pflags = data.user;
				pflags = %[] if pflags === void;
			}
			else
			{
				(Dictionary.assignStruct incontextof pflags)(flags);
			}
			historyOfStore = data.history;
			historyOfStore = [] if historyOfStore === void;
		}
		catch(e)
		{
			System.inform(
				"セーブデータの読み込みに失敗しました\n" +
				"セーブデータファイル(" + fn + ")は壊れているか\n" +
				"別の形式のファイルである可能性があります", "エラー");
			return false;
		}

		restoreFlags();
		return true;
	} incontextof kag;

kag.saveBookMarkToFile = 
	function(fn, savehist = true)
	{
		// ファイル fn に栞を保存する
		if(readOnlyMode) return false;
		pcflags.storeTime = (new Date()).getTime(); // 日付を保存

		// セーブデータをまとめる
		var data = %[];
		data.id = saveDataID;
		data.core = pcflags;
		data.user = pflags;
		if(savehist) data.history = historyOfStore;

		if(saveThumbnail)
		{
			// サムネイルを保存
			lockSnapshot();
			try
			{
				// サムネイルのサイズまで縮小
				var thum = "";
				var tmp = new Layer(this, primaryLayer);
				var size = calcThumbnailSize();
				try
				{
					// サムネイル指定検索
					if(kag.fore.base.imageStorage !== void)
					{
						var regexp = new RegExp("", "i");
						var keys = DictionaryUtils.getKeys(global.SAVE_THUM);
						for(var i = 0; i < keys.count; i++)
						{
							if(global.SAVE_THUM[keys[i]] instanceof "Array")
							{
								for(var j = 0; j < global.SAVE_THUM[keys[i]].count; j++)
								{
									regexp.compile(global.SAVE_THUM[keys[i]][j], "i");
									if(regexp.test(kag.fore.base.imageStorage))
									{
										thum = keys[i];
										break;
									}
								}
								if(thum != "") break;
							}
						}
					}
					
					// サムネイル指定が見つかったらサムネイル画像の読み込みを試行
					if(thum !== "")
					{
						try
						{
							var tmpLayer = new ExLayer();
							tmpLayer.loadImages(thum + "_savethum");
							tmp.setImageSize(size.width, size.height);
							tmp.face = dfAlpha;
							tmp.stretchCopy(0, 0, size.width, size.height, tmpLayer,
								0, 0, tmpLayer.imageWidth, tmpLayer.imageHeight, stLinear);
						}
						catch(e)
						{
							thum = "";
						}
					}
					
					// サムネイル指定がないorサムネイル画像が見つからない場合は通常のレイヤ合成モード
					if(thum === "")
					{
						tmp.setImageSize(size.width, size.height);
						tmp.face = dfAlpha;
						tmp.stretchCopy(0, 0, size.width, size.height, snapshotLayer,
							0, 0, snapshotLayer.imageWidth, snapshotLayer.imageHeight, stLinear);
					}
					
					/*
					// サムネイル画像をセピア調にして保存する場合はコメントアウトを解除
					tmp.doGrayScale();
					tmp.adjustGamma(
									1.3, 0, 255,  // R gamma, floor, ceil
									1.0, 0, 255,  // G gamma, floor, ceil
									0.8, 0, 255); // B gamma, floor, ceil
					*/
					try
					{
						// サムネイルを保存
						tmp.saveLayerImage(fn, "bmp" + thumbnailDepth);
						// データを保存
						var mode = saveDataMode;
						mode += "o" + size.size; // モード文字列に 書き込みオフセットを指定
						(Dictionary.saveStruct incontextof data)(fn, mode);
					}
					catch(e)
					{
						invalidate tmp;
						unlockSnapshot();
						System.inform("ファイルに保存できません (ファイルを開けないか、"
							"書き込み禁止です)");
						return false;
					}
				}
				catch(e)
				{
					invalidate tmp;
					throw e;
				}
				invalidate tmp;
			}
			catch(e)
			{
				unlockSnapshot();
				throw e;
			}
			unlockSnapshot();
		}
		else
		{
			// 通常のファイルに保存
			try
			{
				(Dictionary.saveStruct incontextof data)(fn, saveDataMode);
			}
			catch(e)
			{
				System.inform("ファイルに保存できません (ファイルを開けないか、"
					"書き込み禁止です)");
				return false;
			}
		}

		return true;
	} incontextof kag;

kag.onActivate =
	function() {
		// 最小化からの復帰時に音量が自動復帰しないため(なぜかウィンドウが一度Deactivateしないと復帰しない)、
		// 音量を手動で再設定することで同問題を回避する。
		// (一度0に設定しているのは、現在値からの音量変化がないと再設定しても適用されないため)
		kag.volume.systemMaster = 0;
		kag.volume.systemMaster = global.SYSTEM_VOLUME.MASTER;
	} incontextof kag;

kag.showHistory =
	function()
	{
		if(conductor.status == conductor.mRun)
		{
			skipToClick();
			showHistoryTrigger = showHistoryS;
		}
		else
		{
			showHistoryS();
		}
	} incontextof kag;

kag.showHistoryS =
	function()
	{
		if(!fore.base.inTransition && !back.base.inTransition)
		{
			showHistoryTrigger = void;
			// メッセージ履歴レイヤを表示する
			historyLayer.parent = fore.base; // メッセージ履歴レイヤの親も再設定
			historyLayer.dispInit();
			historyLayer.absolute = fore.messages[0].absolute + 40000;
			historyShowing = true;
			if(typeof this.showHistoryMenuItem != UNDEFINED)
				showHistoryMenuItem.checked = true;
			setMenuAccessibleAll();
		}
	} incontextof kag;

kag.showHistoryTrigger = void;


// =============================================================================
// 左クリックフック
function onLeftClick()
{
	kagLeftClick();
	
	return(true);
}
var kagLeftClick = function()
{
	var st = conductor.status;
	var runst = conductor.mRun;
	var stopst = conductor.mStop;

	if(messageLayerHiding)
	{
		switchMessageLayerHiddenByUser();
	}
	else if(st != stopst && canCancelSkipByClick && skipMode && skipMode != 4)
	{
		// クリックによるスキップの解除が可能
		cancelSkip();
	}
	else
	{
		if(kag.se[global.SOUND_BUFFER.VOICE_REPEAT].status == "play")
		{
			se[global.SOUND_BUFFER.VOICE_REPEAT].stop();
			bgv.autoresume();
		}
		else
		{
			// この時点でフィルタリングされないメッセージは待ち状態のクリアなので
			// conductor に 'click' を送り解除を伝える。		
			if(!conductor.trigger('click')) // 待ち状態でない場合は単に無視される
			{
				// ハンドラが見つからないなど、処理されなかった場合
				if(st == runst && clickSkipEnabled && skipMode == 0)
				{
					// クリックによるスキップが可能
					skipToClick();
				}
			}
			msgWin.setCursorMode(false);
		}
	}
	
	if(autoMode && !diagChoice.visible)
	{
		if(kag.mainConductor.lastTagName == "ori_p") cancelSkip();
		conductor.run();
	}

} incontextof kag;

kag.leftClickHook.add(onLeftClick);

// 右クリックフック
function onRightClick()
{
	if(kag.autoMode)
	{
		kag.cancelAutoMode();
	}
	else if(kag.skipMode)
	{
		kag.cancelSkip();
	}
	else
	{
		if(!kag.msgWin.inTransition()) kag.msgWin.switchMessageLayer();
	}
	
	kag.msgWin.setCursorMode(false);

	return(true);
}
kag.rightClickHook.add(onRightClick);

kag.forceEffect = false;

// store時にクエイク処理によるベースレイヤ位置のズレを強制補正する
class CorrectBaseLayerPosOnStore extends KAGPlugin
{
	function onStore(f, elm)
	{
		if(kag.quaking)
		{
			f.foreBaseLayer.left = 0;
			f.foreBaseLayer.top = 0;
			f.backBaseLayer.left = 0;
			f.backBaseLayer.top = 0;
		}
	}
}
kag.addPlugin(new CorrectBaseLayerPosOnStore());
[endscript]

[macro name=forceeffect]
[eval exp="kag.forceEffect=mp.mode"]
[endmacro]

[return]