; ===== タイトル設定 =====
[iscript]
if (System.debug)
{
	kag.caption = System.title + " Ver." + System.ver + " (release." + System.release + ") - debug mode";
} else {
	kag.caption = System.title + " Ver." + System.ver;
}
dm("rootnuko2019 System Version : " + System.ver + " (release." + System.release + ")" + (System.debug ? " - debug mode" : ""));
[endscript]

; ===== システムサンプル適用 ====
[iscript]
if (System.debug)
{
    Storages.addAutoPath("../sample/");
    if (Storages.isExistentStorage("sample.tjs")) Scripts.execStorage("sample.tjs");
}
[endscript]

; ==== フォント登録 ====
[current layer=message0 page=fore]
[font size=12 face=MPLUS1C12][mappfont storage=MPLUS1C12.tft]
[font size=14 face=MPLUS1C14][mappfont storage=MPLUS1C14.tft]
[font size=16 face=MPLUS1C16][mappfont storage=MPLUS1C16.tft]
[font size=18 face=MPLUS1C18][mappfont storage=MPLUS1C18.tft]
[font size=20 face=MPLUS1C20][mappfont storage=MPLUS1C20.tft]
[font size=22 face=MPLUS1C22][mappfont storage=MPLUS1C22.tft]
[font size=24 face=MPLUS1C24][mappfont storage=MPLUS1C24.tft]
[font size=26 face=MPLUS1C26][mappfont storage=MPLUS1C26.tft]
[font size=28 face=MPLUS1C28][mappfont storage=MPLUS1C28.tft]
[font size=30 face=MPLUS1C30][mappfont storage=MPLUS1C30.tft]
[font size=32 face=MPLUS1C32][mappfont storage=MPLUS1C32.tft]

; ==== 共用ダミーレイヤ作成 ====
[iscript]
kag.dumyLayer = new Layer(kag, kag.fore.base);
kag.dumyLayer.setSize(kag.scWidth, kag.scHeight);
kag.dumyLayer.absolute = kag.fore.base.absolute;
kag.dumyLayer.hitThreshold = 0;
kag.dumyLayer.visible = false;
[endscript]

; ==== 外部スクリプト読込 ====
[call storage="Defines.ks"]
[call storage="Volume.ks"]
[call storage="AskDialog.ks"]
[call storage="ChoiseDialog.ks"]
[call storage="BackGroundVoice.ks"]
[call storage="MessageWindowController.ks"]
[call storage="CountDown.ks"]
[call storage="SaveWindow.ks"]
[call storage="ConfigWindow.ks"]
[call storage="ExHistoryLayer.ks"]
[call storage="ChildImage.ks"]
[call storage="SwitchMessage.ks"]
[call storage="GameParameters.ks"]
[call storage="PlayModeSelect.ks"]
[call storage="NameInput.ks"]
[call storage="Extra.ks"]
[call storage="EyeCatch.ks"]

; KAGシステムハック
[call storage="KagHack.ks"]
[call storage="TagHack.ks"]
[call storage="KeyHook.ks"]

; 拡張KAGプラグイン
[call storage="SaveAnywhere.ks"]
[call storage="highSpeedLabeler.ks"]
[call storage="LayerMotionPlugin.ks"]
[call storage="Zoom.ks"]
[call storage="Eruby.ks"]

; サムネイル定義
[call storage="SettingThum.ks"]

; シナリオ用マクロ登録
[call storage="macro.ks"]

; ハートマークマクロ
[macro name="heart"][graph storage="heart" alt="@" char=false][endmacro]

; 拡張パッチ読み込み
[iscript]
kag.append = [];
kag.appendEnabled = [];
for(var i = 0; i < 99; i++)
{
	if(Storages.isExistentStorage(System.exePath + "append" + i + ".xp3")) {
		Storages.addAutoPath(System.exePath + "append" + i + ".xp3>");
		if(Storages.getPlacedPath("append%d.tjs".sprintf(i)) != "")
		{
			Scripts.execStorage("append%d.tjs".sprintf(i));
			kag.appendEnabled[i] = true;
		}
	}
}
[endscript]

[iscript]
// フラグ初期化
if(sf.cg === void) sf.cg = %[];
if(sf.scene === void) sf.scene = %[];
if(sf.titleNo === void) sf.titleNo = 0;
if(sf.episode === void)
{
    sf.episode = %[];
    sf.episodethum = %[];
}
if(sf.episode.count == 0 || System.debug)
{
    var epiopens = ["ma_love1", "ma_ero1", "hi_love1", "hi_ero1", "ay_love1", "ay_ero1", "yo1", "yu1", "har1"];
    for(var i = 0; i < epiopens.count; i++) kag.sflags.episode[epiopens[i]] = true;
}

// システムボリューム
kag.volume.systemMaster = global.SYSTEM_VOLUME.MASTER;
kag.volume.systemMusic = global.SYSTEM_VOLUME.MUSIC;
kag.volume.systemSound = global.SYSTEM_VOLUME.SOUND;
kag.volume.systemSysSound = global.SYSTEM_VOLUME.SYS_SOUND;
kag.volume.systemVoice = global.SYSTEM_VOLUME.VOICE;
kag.volume.systemBgv = global.SYSTEM_VOLUME.BGV; 
kag.volume.setVolume();
[endscript]

; 割り込み処理実行(デバッグモード時のみ)
[if exp="System.debug && Storages.isExistentStorage('interceptor.ks')"]
	[call storage="interceptor.ks"]
[endif]

; タイトル準備
[call target=*title_prepare]

; タイトルへ
[jump storage="title.ks"]


; //////////////////////////////////////////////////////////////////////////////

; ==== タイトル準備 ====
*title_prepare
[iscript]
// メニューアイテム登録関数
function setTitleItem(lst)
{
	with(lst)
	{
		kag.diagChoice.addButtons(
			.pos.x, .pos.y,
			.image,
			.rect.left, .rect.top, .rect.width, .rect.height,
			.text,
			.storage,
			.target,
			.enabled,
			void,
			.blinkcount,
			.hidetime,
			(.secursor !== void ? .secursor : "enter"),
			(.sechoice !== void ? .sechoice : "click"),
			.cancel
		);
	}
}
[endscript]
[return]

; ==== タイトル画面に戻る時の処理 ====
*titlereturn
[eval exp="prevSetLayer(kag.dumyLayer, true, global.LAYER_ABS.GLOBAL_DUMY, 0, true);"]
[eval exp="kag.diagChoice.hide(0)"]
[msgwin page=no]
[fadeoutbgm time=700]
[eval exp="for(var i = 0; i <= 12; i++) kag.tagHandlers.fadeoutse(%[buf : (string)i, time : 700]);"]
[image page=back layer=base storage="black"]
[eval exp="for(var i = 0; i < 10; i++) kag.tagHandlers.freeimage(%[page : 'back', layer : (string)i]);"]
[stoptrans]
[trans method=crossfade time=700]
[wt canskip=false]
[stopbgm]
[eval exp="for(var i = 0; i <= 12; i++) kag.tagHandlers.stopse(%[buf : (string)i]);"]
[eval exp="for(var i = 0; i <= 12; i++) kag.tagHandlers.seopt(%[buf : (string)i, volume : 100]);"]
[eval exp="kag.bgv.clearReplay();"]
[eval exp="kag.configWindow.hide(0, false)"]
[eval exp="kag.saveWindow.hide(0)"]
[eval exp="kag.mapWalk.hideForce()" cond="typeof kag.mapWalk != UNDEFINED"]
[wait time=800 canskip=false]
[eval exp="kag.dumyLayer.visible=false"]
[eval exp="kag.goToStart()"]

; ==== ゲーム終了時の処理 ====
*gameend
[eval exp="kag.fore.base.enabled=false"]
[eval exp="kag.flags.lockHistory = true;"]
[eval exp="prevSetLayer(kag.dumyLayer, true, global.LAYER_ABS.GLOBAL_DUMY, 0, true);"]
[eval exp="kag.cancelSkip()"]
[clickskip enabled=true]
[msgwin page=no]
[eval exp="kag.diagAsk.enabled = false;"]
[eval exp="kag.diagChoice.hide(0)"]
[msgwin page=no]
[fadeoutbgm time=700]
[eval exp="for(var i = 0; i < 11; i++) kag.tagHandlers.fadeoutse(%[buf : (string)i, time : 700]);"]
[image page=back layer=base storage="black"]
[eval exp="for(var i = 0; i < 10; i++) kag.tagHandlers.freeimage(%[page : 'back', layer : (string)i]);"]
[stoptrans]
[trans method=crossfade time=800]
[wt canskip=false]
[stopbgm]
[stopvideo]
[eval exp="var tmpBuffer = global.SystemSoundFreeBuffer();"]
[playse buf=&tmpBuffer storage="&('exit_' + choiceAtRandomFromArray(global.SYSTEM_VOICE_LIST))" cond="kag.config.SystemVoice && global.SYSTEM_VOICE_LIST.count > 0"]
[ws buf=&tmpBuffer canskip=true cond="kag.config.SystemVoice"]
[eval exp="for(var i = 0; i < 12; i++) kag.tagHandlers.stopse(%[buf : (string)i]);"]
[eval exp="kag.askOnClose = false;"]
[eval exp="WaitTimer.wait(10, function() { global.closeQuery(); })"]
[eval exp="kag.dumyLayer.visible=false"]
[s]
