[iscript]
/*
=============
 InfoMsg定义
=============
＜参数说明＞
 image		: 通知时显示的图像
 sound		: 通知时播放的音效
 condition	: 达成条件
   compat	: 累计相性参数达到此处指定值以上时条件成立。
   throb	: 累计心动参数达到此处指定值以上时条件成立。
   custom	: 使用自定义达成条件时需在此处编写判定处理(function)。
 establish	: 条件成立时执行的处理(例如开启开关等)

＜补充说明＞
①同时指定compat与throb时，需同时满足两个条件方可成立。
  (若希望任一条件满足即成立，请使用custom功能)
②compat及throb条件设为0时，将始终视为条件成立。
③custom指定的function需通过true/false返回判定结果：true为成立/false为不成立。
④同时指定compat,throb,custom时，需所有条件均满足方可成立。
⑤使用custom条件时，可将与InfoMsg无关的其他系统开关作为成立条件，
　亦可使用当前日期等作为判定条件。
　例如在特定日期启动时解锁的隐藏剧情等。
　但当前判定处理仅针对参数上升值运作，
　根据需求需要调整实现。
*/

var INFO_MSG = %[
	infoMsg1 : %[
		image		: "infomsg1",
		sound		: "infomsg",
		condition	: %[custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extramenu = true; }		// 恋人手帳を解放
	],
	infoMsg2a : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 20, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[0] = true; }		// ボイス追加
	],
	infoMsg2b : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 25, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[1] = true; }		// ボイス追加
	],
	infoMsg2c : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 30, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[2] = true; }		// ボイス追加
	],
	infoMsg2d : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 40, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[3] = true; }		// ボイス追加
	],
	infoMsg3 : %[
		image		: "infomsg3",
		sound		: "infomsg",
		type		: "save",
		condition	:%[compat : 20, throb : 0, custom : function(compat, throb) { return global.f.compat_a_open; }],
		establish	: function(){}		// エピソード１『ハイキング』
	],
	infoMsg4 : %[
		image		: "infomsg4",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 25, throb : 0, custom : function(compat, throb) { return global.f.compat_b_open; }],
		establish	: function() {}		// エピソード２『キノコ』
	],
	infoMsg5 : %[
		image		: "infomsg5",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 30, throb : 0, custom : function(compat, throb) { return global.f.compat_c_open; }],
		establish	: function() {}		// エピソード３『交尾』
	],
	infoMsg6 : %[
		image		: "infomsg6",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 20, custom : function(compat, throb) { return global.f.throb_a_open; }],
		establish	: function() {}		// エピソードA『カラオケ』
	],
	infoMsg7 : %[
		image		: "infomsg7",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 25, custom : function(compat, throb) { return global.f.throb_b_open; }],
		establish	: function() {}		// エピソードB『アナル』
	],
	infoMsg8 : %[
		image		: "infomsg8",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 30, custom : function(compat, throb) { return global.f.throb_c_open; }],
		establish	: function() {}		// エピソードC『コスプレ』
	],
	infoMsg9a : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 20, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[0]  = true;
 sf.extraNote.like[1]  = true;
 sf.extraNote.like[2]  = true;
 sf.extraNote.like[3]  = true;
 sf.extraNote.love[0]  = true;
 sf.extraNote.love[1]  = true;
 sf.extraNote.love[2]  = true;
 sf.extraNote.love[3]  = true;
 }
	],
	infoMsg9b : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 30, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[4]  = true;
 sf.extraNote.like[5]  = true;
 sf.extraNote.like[6]  = true;
 sf.extraNote.like[7]  = true;
 sf.extraNote.love[4]  = true;
 sf.extraNote.love[5]  = true;
 sf.extraNote.love[6]  = true;
 sf.extraNote.love[7]  = true;
 }
	],
	infoMsg9c : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 40, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[8]  = true;
 sf.extraNote.like[9]  = true;
 sf.extraNote.like[10]  = true;
 sf.extraNote.love[8]  = true;
 sf.extraNote.love[9]  = true;
 sf.extraNote.love[10]  = true;
 }
	],
	infoMsg10 : %[
		image		: "infomsg10",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 0, custom : function(compat, throb) { return global.f.modeopen; }],
		establish	: function() { sf.extramode = true; }		// 鑑賞モードを開放
	]
];
[endscript]
[return]
