[iscript]
/*
=============
 InfoMsg定義
=============
＜パラメータ説明＞
 image		: 通知時に表示する画像
 sound		: 通知時に再生する効果音
 condition	: 成立条件
   compat	: 累計相性パラメータがここで指定した値以上になると条件成立となります。
   throb	: 累計ときめきパラメータがここで指定した値以上になると条件成立となります。
   custom	: カスタム成立条件を使用する時に判定処理(function)を記述します。
 establish	: 条件成立時に実行する処理を記述します。(フラグをONにするなど)

＜補足＞
①compatとthrobの両方指定した場合は、両条件が満たされた場合のみ条件成立となります。
  (どちらかの条件が満たされた場合に条件成立としたい場合は、customを使用してください)
②compat及びthrob条件に0を指定すると常に条件成立扱いになります。
③customに指定するfunctionは、判定した結果をtrue/falseで返すようにします。true:成立/false:不成立です。
④compat,throb,customを同時に指定した場合は、すべての条件が成立した場合のみ条件成立となります。
⑤custom条件を使用すれば、InfoMsgとは関係のない別のシステムフラグを成立条件として利用したり、
　現在の日付などを条件として利用することも可能です。
　例えば、特定の日に起動すると解放される隠しエピソードなど。
　ただし、現状条件成立の判定処理はパラメータ上昇値にしか動作させてないので、
　要件によって実装の調整が必要です。
*/

var INFO_MSG = %[
	infoMsg1 : %[
		image		: "infomsg1",
		sound		: "infomsg",
		condition	: %[custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extramenu = true; }		// 恋人手帳を解放
	],
	infoMsg2a : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 20, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[0] = true; }		// ボイス追加
	],
	infoMsg2b : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 25, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[1] = true; }		// ボイス追加
	],
	infoMsg2c : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 30, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[2] = true; }		// ボイス追加
	],
	infoMsg2d : %[
		image		: "infomsg2",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 40, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() { sf.extraNote.voice[3] = true; }		// ボイス追加
	],
	infoMsg3 : %[
		image		: "infomsg3",
		sound		: "infomsg",
		type		: "save",
		condition	:%[compat : 20, throb : 0, custom : function(compat, throb) { return global.f.compat_a_open; }],
		establish	: function(){}		// エピソード１『ハイキング』
	],
	infoMsg4 : %[
		image		: "infomsg4",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 25, throb : 0, custom : function(compat, throb) { return global.f.compat_b_open; }],
		establish	: function() {}		// エピソード２『キノコ』
	],
	infoMsg5 : %[
		image		: "infomsg5",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 30, throb : 0, custom : function(compat, throb) { return global.f.compat_c_open; }],
		establish	: function() {}		// エピソード３『交尾』
	],
	infoMsg6 : %[
		image		: "infomsg6",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 20, custom : function(compat, throb) { return global.f.throb_a_open; }],
		establish	: function() {}		// エピソードA『カラオケ』
	],
	infoMsg7 : %[
		image		: "infomsg7",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 25, custom : function(compat, throb) { return global.f.throb_b_open; }],
		establish	: function() {}		// エピソードB『アナル』
	],
	infoMsg8 : %[
		image		: "infomsg8",
		sound		: "infomsg",
		type		: "save",
		condition	: %[compat : 0, throb : 30, custom : function(compat, throb) { return global.f.throb_c_open; }],
		establish	: function() {}		// エピソードC『コスプレ』
	],
	infoMsg9a : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 20, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[0]  = true;
 sf.extraNote.like[1]  = true;
 sf.extraNote.like[2]  = true;
 sf.extraNote.like[3]  = true;
 sf.extraNote.love[0]  = true;
 sf.extraNote.love[1]  = true;
 sf.extraNote.love[2]  = true;
 sf.extraNote.love[3]  = true;
 }
	],
	infoMsg9b : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 30, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[4]  = true;
 sf.extraNote.like[5]  = true;
 sf.extraNote.like[6]  = true;
 sf.extraNote.like[7]  = true;
 sf.extraNote.love[4]  = true;
 sf.extraNote.love[5]  = true;
 sf.extraNote.love[6]  = true;
 sf.extraNote.love[7]  = true;
 }
	],
	infoMsg9c : %[
		image		: "infomsg9",
		sound		: "infomsg",
		condition	: %[compat : 40, throb : 0, custom : function(compat, throb) { return global.f.noteopen; }],
		establish	: function() {
 sf.extraNote.like[8]  = true;
 sf.extraNote.like[9]  = true;
 sf.extraNote.like[10]  = true;
 sf.extraNote.love[8]  = true;
 sf.extraNote.love[9]  = true;
 sf.extraNote.love[10]  = true;
 }
	],
	infoMsg10 : %[
		image		: "infomsg10",
		sound		: "infomsg",
		condition	: %[compat : 0, throb : 0, custom : function(compat, throb) { return global.f.modeopen; }],
		establish	: function() { sf.extramode = true; }		// 鑑賞モードを開放
	]
];
[endscript]
[return]
