# EntisGLS4 Cotopha\bin 工具使用说明文档

## 目录

- [图像转换工具](#图像转换工具)
  - [erisacvt.exe - ERISA图像格式转换器](#erisacvtexe---erisa图像格式转换器)
  - [ffragment.exe - 文件分片工具](#ffragmentexe---文件分片工具)
- [音频处理工具](#音频处理工具)
  - [wav2mio.exe - WAV转MIO音频编码器](#wav2mioexe---wav转mio音频编码器)
  - [WaveMarker.exe - 波形标记工具](#wavemarkerexe---波形标记工具)
- [视频转换工具](#视频转换工具)
  - [avi2mei.exe - AVI转MEI视频转换器](#avi2meiexe---avi转mei视频转换器)
  - [miocoder.exe - MIO编解码器](#micoderexe---mio编解码器)
- [脚本开发工具](#脚本开发工具)
  - [cotoco.exe - Cotopha脚本编译器](#cotocoexe---cotopha脚本编译器)
  - [cotolink.exe - Cotopha脚本链接器](#cotolinkexe---cotopha脚本链接器)
  - [rosetta.exe - Rosetta脚本解释器](#rosettaexe---rosetta脚本解释器)
  - [sakura2vm.exe / sakura2vm_con.exe - Sakura2虚拟机](#sakura2vmexe--sakura2vm_conexe---sakura2虚拟机)
  - [sakura2vm_ogl.exe / sakura2vm_ogl_con.exe - Sakura2 OpenGL虚拟机](#sakura2vm_oglexe--sakura2vm_ogl_conexe---sakura2-opengl虚拟机)
- [构建工具](#构建工具)
  - [cotomake.exe - Cotopha构建工具](#cotomakeexe---cotopha构建工具)
  - [cotobuild.exe - Cotopha项目构建器](#cotobuildexe---cotopha项目构建器)
- [文件工具](#文件工具)
  - [noa32c.exe - NOA32归档器](#noa32cexe---noa32归档器)
  - [noa32w.exe - NOA32 GUI归档器](#noa32wexe---noa32-gui归档器)
  - [scxcopy.exe - 源码转换复制工具](#scxcopyexe---源码转换复制工具)
  - [sigcrc.exe - CRC32签名工具](#sigcrcexe---crc32签名工具)
  - [smplcrypt.exe - 简单加解密工具](#smplcryptexe---简单加解密工具)
- [字体工具](#字体工具)
  - [bmfontmake.exe - 位图字体生成器](#bmfontmakeexe---位图字体生成器)
- [IDE与调试工具](#ide与调试工具)
  - [Primrose2.exe - 脚本IDE](#primrose2exe---脚本ide)
  - [cotomi.exe / cotomi_con.exe - 脚本调试器](#cotomiexe--cotomi_conexe---脚本调试器)
  - [svmpi_debugger.dll - 虚拟机调试库](#svmpi_debuggerdll---虚拟机调试库)
- [项目工具](#项目工具)
  - [newGLS4AndroidProj.exe - Android项目生成器](#newgls4androidprojexe---android项目生成器)

---

## 图像转换工具

### erisacvt.exe - ERISA图像格式转换器

**版本**: 1.07  
**版权**: Copyright (C) 2004-2012 Leshade Entis

#### 功能介绍

ERISA图像转换器是EntisGLS4框架的核心图像处理工具，支持多种图像格式之间的相互转换，特别是ERI/ERINA/ERISA专有格式的编解码。该工具支持PSD、PNG、BMP、TIFF、JPEG、GIF、ICO等主流格式，并提供高级压缩和转换选项。

#### 主要用途

- 将各种图像格式转换为ERI/ERINA/ERISA格式
- 从ERI格式导出为标准图像格式（PNG、BMP等）
- PSD文件的图层处理与转换
- 批量图像转换与压缩
- 支持Hot-Spot坐标信息的提取与写入
- 动画序列图像的转换

#### 命令行格式

```bash
# 格式1: 使用转换配置文件
erisacvt [options] /l <cvtfile(*.xml)>

# 格式2: 使用脚本文件
erisacvt [options] {/Cs | /s} <scriptfile(*.cos)> [/arg ...]

# 格式3: 直接转换文件
erisacvt [options] <source-file> [<destination-file>]
```

#### 参数说明

**格式指定选项**:
- `/mime:<type>` - 指定目标文件的MIME类型
  - `image/x-eri` - ERI格式（默认）
  - `image/x-erina` - ERINA格式
  - `image/x-erisa` - ERISA格式
  - `image/bmp` - Windows位图
  - `image/tiff` - TIFF格式
  - `image/png` - PNG格式
  - `image/jpeg` - JPEG格式
  - `image/gif` - GIF格式
  - `image/x-icon` - ICO图标
  - `image/x-photoshop` - PSD格式
  - `video/avi` - AVI视频

- `/eri` - 转换为ERI格式
- `/erina` - 转换为ERINA格式
- `/erisa` - 转换为ERISA格式

**图像处理选项**:
- `/clip` - 提取源图像信息（包括hot-spot坐标等元数据）
- `/cp#` - 指定ERI格式的输出压缩级别（0-3）
  - `/cp0` - 标准压缩
  - `/cp3` - 标准高品质压缩
- `/blend:<on|off>` - 指定是否合并图层
- `/fps:<value>` - 为动画序列指定每秒帧数

**解码选项** (`/dec:<parameters>`):
- `dither={on|off}` - 是否使用抖动算法（默认on）
- `alpha={on|off}` - 是否包含透明通道（默认on）
- `alpha_dither={on|off}` - 透明通道是否使用抖动（默认on）
- `algorithm={0|1}` - 解码算法选择（默认0）
- `bits={4|8}` - 像素位深度（默认8）
- `colors=[8...256]` - 调色板颜色数（默认256）

**脚本相关选项**:
- `/l <file>` - 指定转换配置文件（XML格式）
- `/s <file>` - 指定脚本文件
- `/Cs <file>` - 指定C风格脚本文件
- `/I <path>` - 指定脚本包含路径
- `/arg <args>` - 传递给脚本main函数的参数

**输出选项**:
- `/r <file>` - 指定报告文件路径
- `/o <file>` - 指定输出文件路径（用于脚本输出）
- `/i` - 显示指定信息文件的内容
- `/nologo` - 不显示版权信息
- `/?` - 显示帮助信息
- `/help` - 显示转换配置文件的帮助

#### 使用示例

**1. PSD转ERI（保留Hot-Spot）**
```bash
erisacvt /nologo /mime:image/x-erina /clip input.psd output.eri
```

**2. PNG转ERINA格式**
```bash
erisacvt /nologo /mime:image/x-erina image.png image.eri
```

**3. ERI转BMP**
```bash
erisacvt /nologo /mime:image/bmp source.eri output.bmp
```

**4. 使用高品质压缩**
```bash
erisacvt /nologo /erina /cp3 input.png output.eri
```

**5. 批量转换（使用通配符）**
```bash
erisacvt /nologo /mime:image/x-erina *.png
```

**6. 使用脚本进行批量转换**
```bash
erisacvt /nologo /Cs psd_convertor.cc /arg /each_layer src_dir dst_dir
```

**7. 解码参数控制**
```bash
erisacvt /nologo /dec:dither=on&alpha=on&bits=8 input.eri output.png
```

#### 注意事项

1. **Hot-Spot信息保持**: 使用`/clip`参数时会提取源文件的hot-spot坐标，但转换后需要手动写入ERI文件的descript块
2. **PSD图层处理**: 默认情况下会合并所有图层，使用`/blend:off`可以分别处理各图层
3. **文件覆盖**: 如果目标文件已存在，会直接覆盖，建议事先备份
4. **编码兼容性**: ERINA格式通常用于无损压缩，ERISA用于有损压缩
5. **批量处理**: 支持通配符和目录操作，输出路径以`\`结尾会被视为目录
6. **脚本模式**: 使用`/Cs`可以执行C风格的自定义转换脚本，提供更灵活的批处理能力

---

### ffragment.exe - 文件分片工具

**版本**: 1.02  
**版权**: Copyright (C) 2011-2015 Leshade Entis

#### 功能介绍

文件分片工具用于将文件进行分片处理，支持ERINA压缩格式。主要用于大文件的分割存储或分布式部署场景。

#### 命令行格式

```bash
ffragment [options] <file-path> [destination-file-path]
```

#### 参数说明

- `/erina` - 使用ERINA格式进行压缩
- `/nologo` - 不显示版权信息
- `/?` - 显示帮助信息
- `<file-path>` - 源文件路径
- `[destination-file-path]` - 目标文件路径（可选）

#### 使用示例

```bash
# 使用ERINA压缩分片
ffragment /erina /nologo large_file.dat output.frag

# 基本分片
ffragment input.bin output.frag
```

#### 注意事项

1. 分片后的文件需要使用对应的工具进行还原
2. ERINA压缩会增加处理时间但减小文件大小
3. 适用于需要分发或分段加载的大型资源文件

---

## 音频处理工具

### wav2mio.exe - WAV转MIO音频编码器

#### 功能介绍

WAV转MIO编码器用于将标准WAV音频文件转换为MIO格式（ERISA音频压缩格式）。MIO格式支持无损和有损压缩，适用于游戏和多媒体应用。

#### 主要特性

- 支持8位/16位PCM音频
- 单声道/立体声支持
- 可选无损压缩（Runlength Huffman）
- 可选有损压缩（LOT/LOT-MSS变换）
- 多种压缩算法支持
- 循环点和元数据标记

#### 使用示例

```bash
# 基本转换
wav2mio input.wav output.mio

# 使用特定压缩参数
wav2mio /preset:high input.wav output.mio
```

#### 相关信息

MIO格式的详细参数可以通过编程接口设置：
- 采样率、声道数、位深度
- 变换类型（无损/LOT/LOT-MSS）
- 压缩架构（Runlength Huffman/Gamma/Nemesis）
- 子带参数和压缩质量

#### 注意事项

1. 输入必须是标准PCM WAV文件
2. 有损压缩仅支持16位音频
3. LOT-MSS适用于立体声高质量压缩
4. 输出文件可包含循环标记等元数据

---

### WaveMarker.exe - 波形标记工具

#### 功能介绍

波形标记工具是一个图形化工具，用于在音频文件中添加循环点、标记点等元数据信息。这些标记可以在MIO格式转换时保留。

#### 主要功能

- 可视化波形显示
- 循环起点/终点标记
- 回放预览功能
- 标记信息导出

#### 使用方式

```bash
# 直接启动GUI界面
WaveMarker.exe

# 打开指定文件
WaveMarker.exe audio_file.wav
```

#### 注意事项

1. 这是一个GUI工具，需要图形界面环境
2. 标记信息可以在转换为MIO格式时保留
3. 支持常见的WAV和MIO音频格式

---

## 视频转换工具

### avi2mei.exe - AVI转MEI视频转换器

**版本**: 1.10a  
**版权**: Copyright (C) 2006-2011 Leshade Entis

#### 功能介绍

AVI转MEI视频转换器用于将AVI视频文件转换为MEI格式（ERISA多媒体容器格式）。MEI格式支持视频和音频流的集成，并提供高效的压缩和流式播放支持。

#### 使用示例

```bash
# 基本转换
avi2mei input.avi output.mei

# 指定压缩参数
avi2mei /quality:high input.avi output.mei
```

#### 注意事项

1. 输入AVI文件应使用标准编解码器
2. MEI格式优化了流式播放性能
3. 支持音视频同步处理

#### MEI转AVI（反向转换）

**重要提示**: bin目录下**没有提供专门的MEI转AVI工具**，但可以通过以下方式实现：

**方案1: 使用MoviePlayer查看**

如果只需要播放MEI文件，可以使用：
```bash
# 使用Rosetta脚本播放MEI
rosetta %COTOPHA_HOME%\Scripts\Tools\src\MoviePlayer.rs /arg video.mei
```

**方案2: 分析MEI文件信息**

项目已在 `Cotopha\Scripts\Tools` 目录提供了Python分析脚本：

```bash
# 查看MEI文件信息
python %COTOPHA_HOME%\Scripts\Tools\mei_info.py video.mei
```

**方案3: 编写自定义转换程序**

对于专业开发人员，可以使用C++或Cotopha脚本调用MEI解码API：
- `SGLMEIMediaInputStream` - MEI文件输入流
- `SGLMovieFilePlayer` - MEI视频播放器  
- `SGLAVIMediaOutputStream` - AVI文件输出流（Windows平台）

参考 `Cotopha\Scripts\Tools\src\MoviePlayer.cc` 获取正确的语法示例。

**方案4: 使用第三方工具**

由于MEI是EntisGLS专有格式，建议使用以下步骤：
1. 使用MoviePlayer播放MEI文件
2. 使用屏幕录制软件录制播放画面
3. 保存为标准视频格式

---

### miocoder.exe - MIO编解码器

#### 功能介绍

MIO编解码器是一个综合性的多媒体编解码工具，支持音频和视频的MIO格式编解码。可用于批量转换、格式验证和参数调整。

#### 使用方式

```bash
# 启动工具（可能需要交互界面）
miocoder.exe

# 通过脚本调用
# 具体参数需参考源码或配置文件
```

#### 注意事项

1. 该工具可能是一个库接口或需要配置文件驱动
2. 详细用法可能需要查阅SDK文档
3. 支持高级压缩参数自定义

---

## 脚本开发工具

### cotoco.exe - Cotopha脚本编译器

**版本**: 3.1019  
**版权**: Copyright (C) 2003-2016 Leshade Entis, Entis-soft

#### 功能介绍

Cotopha脚本编译器是EntisGLS4框架的核心脚本编译工具，支持C风格和传统风格两种语法模式。可以将脚本源代码编译为字节码对象文件，或者直接编译并执行。

#### 命令行格式

```bash
cotoco [options] <script-file(*.cos)> [/arg ...]
```

#### 参数说明

**文件指定**:
- `/Ta <script-file>` - 指定脚本文件路径
- `/Fo <object-file>` - 指定输出对象文件路径（.co）

**编译模式**:
- `/Cs` - C风格模式编译（推荐）
- `/Cc` - C兼容模式编译

**预处理**:
- `/D <macro-name>[=<value>]` - 定义宏变量
- `/M <macro-script>` - 指定宏脚本文件
- `/I <include-path>` - 指定包含文件路径（多个路径用`;`分隔）

**输出控制**:
- `/Fl <listing-file>` - 指定列表文件路径（.lst）

**执行选项**:
- `/X` - 编译后直接执行脚本
- `/nJIT` - 执行时禁用JIT编译器
- `/Lib <library-file>` - 与`/X`配合使用，指定链接的库文件
- `/arg <args>` - 传递给脚本执行的参数

**警告级别**:
- `/W0` - 禁用所有警告
- `/W1` - 仅显示重要警告
- `/W2` - 显示级别0-1的警告（默认）
- `/W3` - 显示级别0-2的警告
- `/W4` - 显示所有警告

**优化选项**:
- `/Od` - 禁用优化
- `/GX` - naked模式下强制所有函数内联
- `/Lfc` - naked模式下所有调用使用far call
- `/La` - 输出所有代码
- `/Ls` - 仅输出静态代码

**其他**:
- `/nologo` - 不显示版权信息
- `/?` - 显示帮助

#### 使用示例

**1. 编译脚本为对象文件**
```bash
cotoco /Cs /Ta script.cc /Fo script.co
```

**2. 编译并立即执行**
```bash
cotoco /nologo /X /Cs script.cc /arg param1 param2
```

**3. 使用宏定义**
```bash
cotoco /Cs /D DEBUG=1 /D VERSION=100 /Ta main.cc /Fo main.co
```

**4. 指定包含路径**
```bash
cotoco /Cs /I ".\include;C:\libs\include" /Ta main.cc
```

**5. 生成列表文件**
```bash
cotoco /Cs /Ta script.cc /Fo script.co /Fl script.lst
```

**6. 批量工具脚本调用**
```bash
cotoco /nologo /X /Cs /Ta dump_ECS_entries.cc /arg "%COTOPHA_HOME%\Include\common\glscs"
```

#### 注意事项

1. **C风格模式**: `/Cs`参数启用更现代的C风格语法，推荐用于新项目
2. **包含路径**: 多个路径使用`;`分隔，路径中有空格需要用引号包围
3. **JIT性能**: 默认启用JIT编译器以提高执行性能，调试时可使用`/nJIT`禁用
4. **警告处理**: 建议使用`/W3`或`/W4`以捕获潜在问题
5. **naked模式**: 用于特殊场景的底层控制，一般开发不需要
6. **脚本参数**: `/arg`后的所有参数都会传递给脚本的main函数

---

### cotolink.exe - Cotopha脚本链接器

**版本**: 3.1019  
**版权**: Copyright (C) 2003-2016 Leshade Entis, Entis-soft

#### 功能介绍

Cotopha脚本链接器用于将多个编译后的对象文件（.co）和脚本库（.csl）链接成可执行的脚本包（.csx）或Windows可执行文件（.exe）。

#### 命令行格式

```bash
cotolink <options> <obj-file-list(*.co;*.csl)> ...
```

#### 参数说明

**输出选项**:
- `/Xo <output-file>` - 指定输出文件路径（.csx/.exe/.bin）
- `/Lo <output-file>` - 输出为库文件（.csl）

**内存配置**:
- `/STACK:<size>` - 设置naked模式默认栈大小（单位：kB）
- `/HEAP:<size>` - 设置naked模式默认堆大小（单位：kB）

**符号处理**:
- `/Tclass` - 在naked模式中删除未使用的类信息
- `/Sclass` - 为naked模式简化类信息
- `/Dsym` - 输出对象文件的符号到标准输出
- `/Delm` - 输出对象文件符号的详细信息
- `/Dcls` - 输出对象文件的类信息

**高级选项**:
- `/OR <override-file>` - 指定覆盖执行信息的文件（.csx）
- `/STUB <stub-pe-file>` - 指定STUB文件（.exe）
- `/E <environment-file>` - 指定环境配置文件（.xml）
- `/CSX <compiled-script>` - 指定编译脚本信息（.csx）
- `/RS` - 将资源编码用于链接到PE文件

**其他**:
- `/nologo` - 不显示版权信息

#### 使用示例

**1. 链接生成可执行脚本包**
```bash
cotolink /Xo program.csx main.co module1.co module2.co
```

**2. 创建脚本库**
```bash
cotolink /Lo mylib.csl utils.co helpers.co
```

**3. 链接为EXE文件**
```bash
cotolink /Xo program.exe /STUB launcher.exe main.co
```

**4. 配置内存大小**
```bash
cotolink /STACK:1024 /HEAP:2048 /Xo game.csx *.co
```

**5. 输出符号信息**
```bash
cotolink /Dsym main.co > symbols.txt
```

**6. 使用环境配置**
```bash
cotolink /E env.xml /Xo app.csx *.co
```

#### 注意事项

1. **文件顺序**: 对象文件的链接顺序可能影响初始化顺序
2. **库文件**: .csl库文件可以被多个项目重用
3. **naked模式**: 适用于特殊嵌入式场景或性能优化
4. **符号信息**: 调试时保留符号信息有助于问题定位
5. **STUB文件**: 创建独立exe时需要合适的launcher stub
6. **内存配置**: 根据脚本复杂度合理设置栈和堆大小

---

### rosetta.exe - Rosetta脚本解释器

**版本**: 0.18  
**版权**: Copyright (C) 2014-2024 Entis soft

#### 功能介绍

Rosetta是EntisGLS4框架的新一代脚本解释器，基于Rust实现，提供更现代的脚本执行环境。支持即时编译、本地代码生成和文档生成功能。

#### 命令行格式

```bash
rosetta [<options>] <script-file>
```

#### 参数说明

**执行控制**:
- `/no_compile` 或 `/NC` - 不编译，直接解释执行
- `/no_native` 或 `/NN` - 不转换为本地字节码
- `/flat_pointer` 或 `/FP` - 编译后使用平面指针模型

**路径配置**:
- `/I <path>` - 指定脚本导入路径

**文档生成**:
- `/doc_dir <path>` - 指定文档输出目录
- `/doc_class <class>` 或 `/DC <class>` - 为指定类生成文档
- `/doc_all_classes` 或 `/DAC` - 为所有类生成文档

**调试选项**:
- `/input` - 从标准输入读取源代码
- `/debug` - 以调试模式运行

**其他**:
- `/logo` - 显示版权信息
- `/arg <args>` - 传递给main函数的参数

#### 使用示例

**1. 基本执行**
```bash
rosetta script.rs
```

**2. 传递参数执行**
```bash
rosetta script.rs /arg param1 param2 param3
```

**3. 生成文档**
```bash
rosetta /doc_dir ".\docs" /doc_all_classes mylib.rs
```

**4. 调试模式**
```bash
rosetta /debug /logo test.rs
```

**5. 指定导入路径**
```bash
rosetta /I ".\libs;.\modules" main.rs /arg config.xml
```

**6. 解释执行（不编译）**
```bash
rosetta /NC /no_native script.rs
```

**7. 实际项目中的调用示例**
```bash
rosetta cvtpsd2form.rs /arg /dst_dir output /form form.xmlfrm /comp comp.xmlprs input.psd
```

#### 注意事项

1. **编译模式**: 默认会编译为本地字节码以提高性能
2. **文档生成**: 可以自动从脚本生成API文档
3. **导入路径**: 支持多个导入路径，用分号分隔
4. **平面指针**: 某些场景下可优化内存访问性能
5. **调试模式**: 提供额外的运行时检查和错误信息
6. **Rust实现**: 相比cotoco有更好的内存安全性和性能

---

### sakura2vm.exe / sakura2vm_con.exe - Sakura2虚拟机

#### 功能介绍

Sakura2虚拟机是用于执行编译后的Cotopha脚本的运行时环境。提供GUI版本（sakura2vm.exe）和控制台版本（sakura2vm_con.exe）。

#### 主要功能

- 执行.csx脚本包
- 提供完整的运行时环境
- 支持调试器连接
- 内存管理和垃圾回收
- 异常处理机制

#### 使用方式

```bash
# GUI版本
sakura2vm.exe script.csx

# 控制台版本
sakura2vm_con.exe script.csx [args]
```

#### 注意事项

1. GUI版本适用于带窗口的应用程序
2. 控制台版本适用于命令行工具和后台服务
3. 需要配合调试库svmpi_debugger.dll使用
4. 支持JIT编译优化

---

### sakura2vm_ogl.exe / sakura2vm_ogl_con.exe - Sakura2 OpenGL虚拟机

#### 功能介绍

Sakura2 OpenGL虚拟机是集成了OpenGL渲染支持的虚拟机版本，专门用于图形应用和游戏开发。

#### 主要功能

- 执行带图形渲染的脚本
- OpenGL硬件加速支持
- 着色器程序支持
- 纹理和几何图形处理

#### 使用方式

```bash
# GUI OpenGL版本
sakura2vm_ogl.exe graphics_app.csx

# 控制台OpenGL版本
sakura2vm_ogl_con.exe renderer.csx
```

#### 注意事项

1. 需要系统支持OpenGL
2. 适用于2D/3D图形应用开发
3. 提供硬件加速渲染能力
4. 支持GLSL着色器

---

## 构建工具

### cotomake.exe - Cotopha构建工具

**版本**: 2.1011  
**版权**: Copyright (C) 2003-2013 Entis-soft

#### 功能介绍

Cotopha构建工具是一个自动化构建系统，类似于Make工具，用于管理复杂的编译和构建流程。通过makefile配置文件定义构建规则和依赖关系。

#### 命令行格式

```bash
cotomake [options] <make-file>
```

#### 参数说明

- `/A` - 强制重新构建所有目标
- `/I` - 禁用命令的返回代码检查
- `/T <target-file>` - 指定要构建的目标文件
- `/M <name>=<macro-string>` - 覆盖定义宏变量
- `/S <macroset-name>` - 激活宏集
- `/serial` - 串行执行所有命令（不使用并行）
- `/below` - 以低于正常的优先级运行命令
- `/time` - 显示所有处理的耗时统计
- `/nologo` - 不显示版权信息
- `/?` - 显示帮助

#### 使用示例

**1. 基本构建**
```bash
cotomake makefile
```

**2. 完全重新构建**
```bash
cotomake /A project.make
```

**3. 构建特定目标**
```bash
cotomake /T game.csx build.make
```

**4. 覆盖宏定义**
```bash
cotomake /M CONFIG=Release /M PLATFORM=x64 build.make
```

**5. 显示耗时统计**
```bash
cotomake /time /nologo project.make
```

**6. 串行构建（调试用）**
```bash
cotomake /serial /I debug.make
```

#### 注意事项

1. **makefile格式**: 使用Cotopha特有的makefile语法
2. **依赖管理**: 自动检测文件修改时间和依赖关系
3. **并行构建**: 默认启用并行处理以加快构建速度
4. **宏系统**: 支持灵活的宏定义和宏集切换
5. **错误处理**: 默认在命令失败时停止，使用`/I`可以继续
6. **优先级**: 使用`/below`可以避免构建时影响系统响应

---

### cotobuild.exe - Cotopha项目构建器

#### 功能介绍

Cotopha项目构建器是一个更高层次的项目管理工具，可能提供GUI界面或项目配置向导功能。

#### 使用方式

```bash
# 启动构建器
cotobuild.exe

# 可能支持项目文件参数
cotobuild.exe project.cbproj
```

#### 注意事项

1. 该工具可能提供图形化项目管理界面
2. 用于管理大型多模块项目
3. 可能集成了版本控制和依赖管理功能

---

## 文件工具

### noa32c.exe - NOA32归档器

**版本**: 1.10A  
**版权**: Copyright (c) 2002-2014 Leshade Entis, Entis-soft

#### 功能介绍

NOA32归档器是EntisGLS4的资源打包工具，用于创建、提取和管理NOA归档文件。支持压缩、加密和密码保护功能。

#### 命令行格式

```bash
# 创建/添加归档
noa32c [options] [<source-file>] <destination>

# 提取归档
noa32c [options] <archive-file> <destination-dir>
```

#### 参数说明

**操作模式**:
- `/p` - 打包模式（创建归档）
- `/x` - 提取模式（解压归档）
- `/c` - 比较归档内容

**压缩选项**:
- `/naked` - 不压缩，直接打包原始文件
- `/r` - 不递归处理子目录
- `/raw` - 以原始数据方式归档
- `/erisa` - 使用ERISA压缩算法打包
- `/crypt` - 使用简单加密打包
- `/erisa_crypt` - 使用ERISA压缩+加密打包

**密码保护**:
- `/pass <password>` - 设置密码
- `/gp` - 打包时交互式输入密码

**其他**:
- `/l <list-file>` - 使用列表文件指定要打包的文件
- `/d` - 包含子目录进行归档
- `/time` - 显示压缩/解压耗时

#### 使用示例

**1. 创建简单归档**
```bash
noa32c /p resources.noa *.png *.wav
```

**2. 创建压缩归档**
```bash
noa32c /p /erisa game_data.noa assets\*.*
```

**3. 创建加密归档**
```bash
noa32c /p /erisa_crypt /pass mypassword /d data.noa game_files\
```

**4. 使用列表文件打包**
```bash
noa32c /p /l filelist.txt archive.noa
```

**5. 提取归档**
```bash
noa32c /x archive.noa output_dir\
```

**6. 带密码提取**
```bash
noa32c /x /pass mypassword encrypted.noa extract\
```

**7. 比较归档内容**
```bash
noa32c /c archive.noa
```

**8. 递归打包目录**
```bash
noa32c /p /d /erisa project.noa src\
```

#### 文件列表格式

列表文件（用于`/l`参数）每行一个文件路径：
```
assets\image1.png
assets\image2.png
sounds\bgm.wav
data\config.xml
```

#### 注意事项

1. **压缩算法**: `/erisa`提供较好的压缩比，适用于资源文件
2. **加密强度**: `/crypt`是简单加密，`/erisa_crypt`更安全
3. **密码管理**: 使用`/gp`可以避免密码在命令行中暴露
4. **通配符**: 支持`*`和`?`通配符进行批量操作
5. **子目录**: 使用`/d`会保留目录结构
6. **性能**: 大文件打包建议使用`/time`监控进度

---

### noa32w.exe - NOA32 GUI归档器

#### 功能介绍

NOA32 GUI归档器是noa32c的图形化版本，提供可视化的归档文件管理界面。

#### 主要功能

- 拖放式文件添加
- 可视化归档浏览
- 图形化压缩选项配置
- 密码设置对话框
- 进度显示

#### 使用方式

```bash
# 启动GUI
noa32w.exe

# 打开归档文件
noa32w.exe archive.noa
```

#### 注意事项

1. 提供更友好的用户体验
2. 适合非技术用户使用
3. 支持所有noa32c的核心功能
4. 需要图形界面环境

---

### scxcopy.exe - 源码转换复制工具

**版权**: Copyright (c) 2012-2025 Leshade Entis

#### 功能介绍

源码转换复制工具用于在复制源代码文件时进行编码转换、条件编译处理和注释优化。主要用于跨平台项目的源码迁移和多语言支持。

#### 命令行格式

```bash
scxcopy [<options>] <source-path> <destination-path>
```

#### 参数说明

**复制选项**:
- `/A` - 强制复制，不比较时间戳
- `/D` - 递归复制子目录
- `/F` - source-path是文件路径（支持通配符）

**编码转换**:
- `/Es <encoding>` - 源文件编码（默认：shift_jis）
- `/Ed <encoding>` - 目标文件编码（默认：utf-8）
- `/BOM` - 当输出为utf-8/utf-16时添加BOM标记

**预处理**:
- `/C` - 处理#if条件编译指令
- `/V <name>=<val>` - 定义#if条件中使用的变量
- `/SD` - 删除注释并优化为瘦身版
- `/XD <path>` - 排除指定目录（可多次使用）

#### 支持的编码

- `shift_jis` - 日文Shift-JIS编码
- `utf-8` - UTF-8编码
- `euc-jp` - 日文EUC编码

#### 使用示例

**1. 基本编码转换**
```bash
scxcopy /Es shift_jis /Ed utf-8 src\ dst\
```

**2. 转换并添加BOM**
```bash
scxcopy /Es shift_jis /Ed utf-8 /BOM source.cpp dest.cpp
```

**3. 条件编译处理**
```bash
scxcopy /C /V DEBUG=1 /V PLATFORM=WIN32 src\ build\
```

**4. 删除注释优化**
```bash
scxcopy /SD /Es shift_jis /Ed utf-8 original\ optimized\
```

**5. 递归复制目录**
```bash
scxcopy /D /Es shift_jis /Ed utf-8 .\Source .\UTF8Source
```

**6. 排除特定目录**
```bash
scxcopy /D /XD temp /XD backup /Es shift_jis /Ed utf-8 src\ dst\
```

**7. 使用通配符复制文件**
```bash
scxcopy /F /Es shift_jis /Ed utf-8 "src\*.cpp" dst\
```

**8. 实际项目中的使用**
```bash
scxcopy /nologo /SD /Es shift_jis /Ed utf-8 "%COTOPHA_HOME%\Source\glsl" glsl.bin
```

#### 注意事项

1. **编码检测**: 工具会尝试自动检测源文件编码
2. **条件编译**: `/C`参数需要配合`/V`定义变量值
3. **注释处理**: `/SD`会移除所有注释，用于发布版本
4. **BOM标记**: UTF-8 BOM可能影响某些工具，按需使用
5. **目录排除**: 可以多次使用`/XD`排除多个目录
6. **时间戳**: 默认只复制较新的文件，`/A`强制全部复制

---

### sigcrc.exe - CRC32签名工具

**版本**: 1.02  
**版权**: Copyright (C) 2011-2016 Leshade Entis

#### 功能介绍

CRC32签名工具用于计算文件的CRC32校验和，可以生成签名文件用于版本验证和完整性检查。

#### 命令行格式

```bash
sigcrc [options] <file-path(s)> [<destination-path>]
```

#### 参数说明

- `/nologo` - 不显示版权信息
- `/p` - 将输出合并到单个目标文件
- `/?` - 显示帮助
- `<file-path(s)>` - 要计算CRC的文件路径（支持通配符）
- `[<destination-path>]` - 输出文件路径

#### 使用示例

**1. 计算单个文件CRC**
```bash
sigcrc file.dat
```

**2. 批量计算CRC**
```bash
sigcrc *.exe *.dll
```

**3. 输出到文件**
```bash
sigcrc /p game_files\*.* checksums.txt
```

**4. 静默模式**
```bash
sigcrc /nologo /p assets\* asset_checksums.crc
```

#### 注意事项

1. CRC32用于快速校验，不适用于安全性要求高的场景
2. 可用于资源文件的版本管理
3. 输出格式可被其他工具读取
4. 支持批量文件处理

---

### smplcrypt.exe - 简单加解密工具

#### 功能介绍

简单加解密工具提供基础的文件加密和解密功能，用于保护资源文件或配置文件。

#### 命令行格式

```bash
smplcrypt {/e|/d} <密码> <输入文件> <输出文件>
```

#### 参数说明

- `/e` - 加密模式
- `/d` - 解密模式
- `<密码>` - 加密/解密密码
- `<输入文件>` - 源文件路径
- `<输出文件>` - 目标文件路径

#### 使用示例

**1. 加密文件**
```bash
smplcrypt /e mypassword config.xml config.dat
```

**2. 解密文件**
```bash
smplcrypt /d mypassword config.dat config.xml
```

**3. 批处理加密**
```batch
@echo off
for %%f in (*.txt) do (
    smplcrypt /e secretkey "%%f" "encrypted\%%f.enc"
)
```

#### 注意事项

1. **安全性**: 这是简单加密，不适用于高安全需求
2. **密码强度**: 使用足够复杂的密码
3. **密码管理**: 妥善保管密码，丢失无法恢复
4. **文件完整性**: 加密前建议备份原文件
5. **用途**: 适用于防止普通用户修改配置文件

---

## 字体工具

### bmfontmake.exe - 位图字体生成器

**版本**: 1.03

#### 功能介绍

位图字体生成器用于将系统字体转换为EntisGLS4的位图字体格式（.bmf），用于游戏和应用程序的文本渲染。

#### 命令行格式

```bash
bmfontmake [options...]
```

#### 参数说明

- `/nologo` - 不显示版权信息
- `/c <xml-file>` - 指定转换配置文件
- `/o <file-name>` - 指定输出文件路径（.bmf）
- `/q <file-name>` - 指定查询文件路径（.bmf）
- `/size <size>[,...]` - 指定要生成的字体大小列表
- `/font <face-name>` - 指定源字体名称
- `/dump_chars` - 导出查询文件中包含的字符
- `/dump_chars_utf8` - 导出字符（UTF-8编码）
- `/?` - 显示帮助

#### 使用示例

**1. 生成单一大小字体**
```bash
bmfontmake /font "MS Gothic" /size 16 /o font16.bmf
```

**2. 生成多种大小**
```bash
bmfontmake /font Arial /size 12,14,16,18,20 /o arial_multi.bmf
```

**3. 使用配置文件**
```bash
bmfontmake /c font_config.xml /o custom_font.bmf
```

**4. 导出字符列表**
```bash
bmfontmake /q game_font.bmf /dump_chars_utf8 > charlist.txt
```

**5. 静默生成**
```bash
bmfontmake /nologo /font "Yu Gothic" /size 14 /o ui_font.bmf
```

#### 配置文件格式

配置文件（XML格式）可以指定：
- 字符集范围
- 抗锯齿选项
- 字体样式（粗体、斜体）
- 输出优化选项

示例配置：
```xml
<bmfont>
  <font face="MS Gothic" size="16" bold="false" italic="false"/>
  <charset>
    <range start="0x20" end="0x7E"/><!-- ASCII -->
    <range start="0x3000" end="0x9FFF"/><!-- 日文汉字 -->
  </charset>
  <options antialias="true" optimize="true"/>
</bmfont>
```

#### 注意事项

1. **字体版权**: 确保有权使用指定的系统字体
2. **字符集**: 根据需要选择合适的字符范围以控制文件大小
3. **大小列表**: 一次生成多个大小可以减少重复操作
4. **抗锯齿**: 根据目标分辨率选择是否启用
5. **查询功能**: 可以检查已生成字体包含哪些字符
6. **性能**: 大字符集+大字号会生成较大的文件

---

## IDE与调试工具

### Primrose2.exe - 脚本IDE

#### 功能介绍

Primrose2是EntisGLS4框架的集成开发环境，提供脚本编辑、调试、项目管理等功能。分为x86和x86_64两个版本。

#### 主要功能

- 语法高亮编辑器
- 代码补全和智能提示
- 集成调试器
- 项目管理
- 脚本编译和执行
- 性能分析工具

#### 版本说明

- **x86版本**: `Primrose2\x86\Primrose2.exe` (约16.97MB)
- **x86_64版本**: `Primrose2\x86_64\Primrose2.exe` (约19.96MB)

#### 使用方式

```bash
# 启动IDE
Primrose2\x86\Primrose2.exe

# 打开项目
Primrose2\x86\Primrose2.exe project.prj

# 打开脚本文件
Primrose2\x86\Primrose2.exe script.cos
```

#### 特性

1. **多标签编辑**: 同时编辑多个脚本文件
2. **语法检查**: 实时错误提示
3. **断点调试**: 设置断点、单步执行、变量查看
4. **项目模板**: 快速创建新项目
5. **代码重构**: 重命名、提取方法等
6. **版本控制**: 可能集成了Git支持

#### 文档位置

IDE相关文档位于：
- `Primrose2\x86\doc\`
- `Primrose2\x86_64\doc\`

#### 注意事项

1. **版本选择**: 根据系统架构选择对应版本
2. **项目文件**: .prj格式的项目配置文件
3. **调试器**: 需要配合svmpi_debugger.dll使用
4. **性能**: x86_64版本在处理大型项目时性能更好

---

### cotomi.exe / cotomi_con.exe - 脚本调试器

#### 功能介绍

Cotopha脚本调试器提供独立的脚本调试功能，支持GUI模式和控制台模式。

#### 主要功能

- 断点管理
- 单步执行（步入、步过、步出）
- 变量监视
- 调用栈查看
- 表达式求值
- 内存查看

#### 使用方式

```bash
# GUI调试器
cotomi.exe script.csx

# 控制台调试器
cotomi_con.exe script.csx
```

#### 调试命令

常用调试命令（控制台模式）：
- `b <line>` - 设置断点
- `c` - 继续执行
- `s` - 单步执行
- `n` - 下一行
- `p <var>` - 打印变量
- `bt` - 显示调用栈
- `q` - 退出调试

#### 注意事项

1. **符号信息**: 需要脚本编译时保留调试符号
2. **GUI vs 控制台**: GUI版本提供更友好的界面
3. **远程调试**: 可能支持连接到远程虚拟机
4. **性能分析**: 可以监控脚本性能瓶颈

---

### svmpi_debugger.dll - 虚拟机调试库

#### 功能介绍

虚拟机调试库是Sakura2虚拟机的调试接口实现，为IDE和调试器提供底层调试支持。

#### 主要功能

- 提供调试协议接口
- 支持断点和单步执行
- 变量和内存访问
- 异常拦截
- 性能监控

#### 使用说明

这是一个库文件，不直接执行，而是被以下工具加载：
- Primrose2 IDE
- cotomi调试器
- sakura2vm虚拟机（调试模式）

#### 接口

调试库提供的接口包括：
- 设置/清除断点
- 执行控制（运行/暂停/步进）
- 读写变量值
- 获取调用栈
- 捕获异常

#### 注意事项

1. **版本兼容**: 需要与虚拟机版本匹配
2. **调试性能**: 启用调试会降低脚本执行速度
3. **发布版本**: 正式发布时不需要此库

---

## 项目工具

### newGLS4AndroidProj.exe - Android项目生成器

#### 功能介绍

Android项目生成器用于快速创建EntisGLS4的Android应用项目框架，包含必要的JNI配置、AndroidManifest和构建脚本。

#### 主要功能

- 创建标准Android项目结构
- 生成JNI接口代码
- 配置构建环境
- 设置项目属性
- 创建示例代码

#### 使用方式

```bash
# 启动项目向导（可能是GUI）
newGLS4AndroidProj.exe

# 或者通过命令行参数
newGLS4AndroidProj.exe /name MyGame /package com.example.mygame /path D:\Projects
```

#### 生成的项目结构

典型的项目结构：
```
MyGame/
├── AndroidManifest.xml
├── jni/
│   ├── Android.mk
│   ├── Application.mk
│   └── src/
├── res/
├── assets/
└── build scripts
```

#### 配置选项

可能包含的配置：
- 项目名称
- 包名
- 最小API级别
- 目标API级别
- 屏幕方向
- 权限设置

#### 注意事项

1. **环境要求**: 需要配置Android NDK和SDK
2. **API级别**: 项目记录显示支持API 18
3. **JNI构建**: 使用项目提供的JNI模板
4. **COTOPHA_HOME**: 需要设置环境变量指向Cotopha目录
5. **构建脚本**: 生成的.bat脚本用于自动化构建

---

## 附录

### A. 常见工作流程

#### 1. 图像资源处理流程

```bash
# 1. PSD转ERI（保留hot-spot）
erisacvt /nologo /mime:image/x-erina /clip source.psd temp.eri

# 2. 如果需要修改hot-spot，使用Python工具
python png2eri_with_hotspot.py

# 3. 批量转换
for %%f in (*.png) do erisacvt /nologo /erina "%%f"
```

#### 2. 脚本开发流程

```bash
# 1. 编译脚本
cotoco /Cs /Ta main.cc /Fo main.co

# 2. 链接生成可执行包
cotolink /Xo game.csx main.co utils.co

# 3. 运行测试
sakura2vm.exe game.csx

# 4. 或使用Rosetta
rosetta main.rs /arg config.xml
```

#### 3. 资源打包流程

```bash
# 1. 转换图像资源
erisacvt /nologo /erina images\*.png

# 2. 转换音频资源
wav2mio sounds\*.wav

# 3. 创建归档
noa32c /p /erisa /d game_data.noa assets\

# 4. 可选：加密归档
noa32c /p /erisa_crypt /pass secretkey final.noa assets\
```

#### 4. Android项目构建流程

```bash
# 1. 创建项目
newGLS4AndroidProj.exe

# 2. 编译脚本
cotoco /Cs /Ta game_main.cc

# 3. 链接
cotolink /Xo android_game.csx *.co

# 4. 构建JNI
cd Makes\Android
call make_api18.bat

# 5. 复制库文件
call copy_lib_to_env_api18.bat
```

### B. 环境变量

推荐设置的环境变量：

```batch
set COTOPHA_HOME=D:\EntisGLS4.07.03\Cotopha
set PATH=%PATH%;%COTOPHA_HOME%\bin
```

### C. 文件格式说明

**脚本相关**:
- `.cos` - Cotopha脚本源文件
- `.cc` - C风格脚本源文件
- `.rs` - Rosetta脚本源文件
- `.co` - 编译后的对象文件
- `.csl` - 脚本库文件
- `.csx` - 可执行脚本包

**图像相关**:
- `.eri` - ERISA图像文件
- `.erina` - ERINA无损图像
- `.erisa` - ERISA有损图像

**音频相关**:
- `.mio` - ERISA音频文件
- `.mei` - ERISA多媒体容器

**归档相关**:
- `.noa` - NOA32归档文件

**其他**:
- `.bmf` - 位图字体文件
- `.xml` - 配置文件
- `.lst` - 编译列表文件

### D. 技术支持

- 项目主页: EntisGLS4框架
- 版本: 4.07.03
- 版权方: Leshade Entis / Entis-soft

### E. 版本历史

各工具版本信息：
- erisacvt: v1.07 (2004-2012)
- cotoco/cotolink: v3.1019 (2003-2016)
- rosetta: v0.18 (2014-2024)
- noa32c: v1.10A (2002-2014)
- bmfontmake: v1.03
- cotomake: v2.1011 (2003-2013)

---

## 结语

本文档涵盖了EntisGLS4.07.03项目中Cotopha\bin目录下的所有工具。每个工具都有其特定的用途，组合使用可以完成完整的游戏或多媒体应用开发流程。

建议开发者：
1. 从简单示例开始熟悉各工具
2. 参考项目中的批处理脚本学习实际用法
3. 根据需要查阅具体工具的详细参数
4. 建立自己的工作流程和自动化脚本

如有问题，请参考工具的`/?`帮助输出或查阅源码中的相关文档。
